<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * It is also available at this URL: http://www.gnu.org/licenses/gpl-3.0.txt
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/* =================== DEFAULT OPTIONS =================== */

$plugin_options = array (

	array (
		'name' => 'Navigation',
		'type' => 'navigation',
		'item' => 
			
			array(

				'Plugin_Settings' => esc_html__( 'Plugin settings','related-posts-by-themeinprogress'),
				'free_vs_pro' => esc_html__( 'Free vs Pro','related-posts-by-themeinprogress'),
				TIPRP_SALE_PAGE . 'tiprp-panel'	=> esc_html__( 'Upgrade to Premium','related-posts-by-themeinprogress'),

			),

		'start' => '<ul>',
		'end' => '</ul>'
	),

	array(	'tab' => 'Plugin_Settings',
			'element' =>

		array(	'type' => 'start-form',
				'name' => 'Plugin_Settings'),

			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Appearance settings','related-posts-by-themeinprogress'),
				'section' => 'appearance_section',
			),

				array(
					'name' => esc_html__( 'Layout', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Choose the layout style for the related posts section.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_layout',
					'type' => 'select',
					'options' => array(
						'hero-layout' => esc_html__( 'Hero Layout', 'related-posts-by-themeinprogress' ),
						'list-layout' => esc_html__( 'List Layout', 'related-posts-by-themeinprogress' ),
						'html-list-layout' => esc_html__( 'HTML List Layout', 'related-posts-by-themeinprogress' ),
					),
					'std' => 'hero-layout'
				),

				array(
					'name' => esc_html__( 'Columns', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the number of columns for displaying the related posts in a grid format.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_columns',
					'type' => 'select',
					'options' => array(
						'1-column' => esc_html__( 'One Column', 'related-posts-by-themeinprogress' ),
						'2-columns' => esc_html__( 'Two Columns', 'related-posts-by-themeinprogress' ),
						'3-columns' => esc_html__( 'Three Columns', 'related-posts-by-themeinprogress' ),
					),
					'std' => '3-columns'
				),
				
				array(
					'name' => esc_html__( 'Content Alignment', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Set the alignment of the content within the related posts section.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_content_align',
					'type' => 'select',
					'options' => array(
						'left' => esc_html__( 'Left', 'related-posts-by-themeinprogress' ),
						'center' => esc_html__( 'Center', 'related-posts-by-themeinprogress' ),
						'right' => esc_html__( 'Right', 'related-posts-by-themeinprogress' ),
					),
					'std' => 'left'
				),
			
				array(
					'name' => esc_html__( 'Border Color', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Choose the color for the border surrounding the related posts section.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_bordercolor',
					'type' => 'color',
					'std' => '#dddddd'
				),

				array(
					'name' => esc_html__( 'Links Hover Color', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Define the hover color for links.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_linkscolorhover',
					'type' => 'color',
					'std' => '#e74c3c'
				),
				
				array(
					'name' => esc_html__( 'Top Margin', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the margin space above the related posts section.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_margintop',
					'type' => 'text',
					'std' => '15px'
				),
				
				array(
					'name' => esc_html__( 'Bottom Margin', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the margin space below the related posts section.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_marginbottom',
					'type' => 'text',
					'std' => '15px'
				),

				array(
					'type' => 'save-button',
					'value' => 'Save',
					'class' => 'General'
				),

			array(
				'type' => 'end-container'
			),
	
			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Post elements settings','related-posts-by-themeinprogress'),
				'section' => 'post_elements_section',
			),

				array(
					'name' => esc_html__( 'Enable the section title', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Would you like to display the section title?', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_enable_section_title',
					'type' => 'switch',
					'std' => 'on',
				),

				array(
					'name' => esc_html__( 'Section title', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Insert the title of the related posts section.', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_section_title',
					'type' => 'text',
					'std' => esc_html__( 'You may be interested', 'related-posts-by-themeinprogress' ),
				),

				array(
					'name' => esc_html__( 'Enable the post title', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Would you like to display the post title?', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_enable_post_title',
					'type' => 'switch',
					'std' => 'on',
				),
				
				array(
					'name' => esc_html__( 'Enable the post date', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Would you like to display the post date?', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_enable_post_date',
					'type' => 'switch',
					'std' => 'on',
				),
				
				array(
					'name' => esc_html__( 'Enable the post author', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Would you like to display the post author?', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_enable_post_author',
					'type' => 'switch',
					'std' => 'on',
				),
				
				array(
					'name' => esc_html__( 'Enable the post author label', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Would you like to display the post author label?', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_enable_post_author_label',
					'type' => 'switch',
					'std' => 'on',
				),
				
				array(
					'name' => esc_html__( 'Enable the post summary', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Would you like to display the post summary?', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_enable_post_summary',
					'type' => 'switch',
					'std' => 'on',
				),
				
				array(
					'type' => 'save-button',
					'value' => 'Save',
					'class' => 'General'
				),

			array(
				'type' => 'end-container'
			),
				
			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Typography settings','related-posts-by-themeinprogress'),
				'section' => 'typography_section',
			),

				array(
					'name' => esc_html__( 'Section title font size', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the font size for title of the related posts section', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_section_title_fontsize',
					'type' => 'text',
					'std' => '18px',
				),

				array(
					'name' => esc_html__( 'Post title font size', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the font size for post titles', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_title_fontsize',
					'type' => 'text',
					'std' => '18px',
				),
				
				array(
					'name' => esc_html__( 'Post meta font size', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the font size for post metadata (e.g., author, date)', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_postmeta_fontsize',
					'type' => 'text',
					'std' => '12px',
				),
				
				array(
					'name' => esc_html__( 'Post summaries font size', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the font size for post summaries', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_postsummary_fontsize',
					'type' => 'text',
					'std' => '14px',
				),
				
				array(
					'name' => esc_html__( 'Default font size (Mobile)', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the default font size on mobile devices (CSS media query: 0 to 480px).', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_mobile_fontsize',
					'type' => 'text',
					'std' => '14px',
				),
				
				array(
					'name' => esc_html__( 'Default font size (Tablet)', 'related-posts-by-themeinprogress' ),
					'desc' => esc_html__( 'Specify the default font size on tablet devices (CSS media query: 481px to 768px).', 'related-posts-by-themeinprogress' ),
					'id' => 'tiprp_tablet_fontsize',
					'type' => 'text',
					'std' => '16px',
				),
				
				array(
					'type' => 'save-button',
					'value' => 'Save',
					'class' => 'General'
				),

			array(
				'type' => 'end-container'
			),
	
			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Search engine settings','related-posts-by-themeinprogress'),
				'section' => 'search_engine_section',
			),

				array(
					'name' => esc_html__( 'Posts count','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'How many related posts do you want to display?.','related-posts-by-themeinprogress'),
					'id' => 'tiprp_count',
					'type' => 'number',
					'std' => 3,
					'input_attrs' => array(
						'min' => 1
					)
				),

				array(
					'name' => esc_html__( 'Search engine','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'How do you want to get the related posts?.','related-posts-by-themeinprogress'),
					'id' => 'tiprp_enginesearch',
					'type' => 'select',
					'options' => array(
						'categories' => esc_html__( 'Based of post categories','related-posts-by-themeinprogress'),
						'tags' => esc_html__( 'Based of post tags','related-posts-by-themeinprogress'),

					),
					'std' => 'categories'
				),

				array(
					'name' => esc_html__( 'Target attribute','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'Set _blank to open the related posts in a new window.','related-posts-by-themeinprogress'),
					'id' => 'tiprp_targetattribute',
					'type' => 'select',
					'options' => array(
						'' => esc_html__( '_self','related-posts-by-themeinprogress'),
						'_blank' => esc_html__( '_blank','related-posts-by-themeinprogress'),
					),
					'std' => ''
				),

				array(
					'name' => esc_html__( 'Rel attribute','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'Set the rel attribute for the related posts.','related-posts-by-themeinprogress'),
					'id' => 'tiprp_relattribute',
					'type' => 'select',
					'options' => array(
						'' => esc_html__( 'dofollow','related-posts-by-themeinprogress'),
						'nofollow' => esc_html__( 'nofollow','related-posts-by-themeinprogress'),
					),
					'std' => ''
				),

				array(
					'name' => esc_html__( 'the_content hook priority','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'If the related posts does not show, please change the priority of the_content hook.','related-posts-by-themeinprogress'),
					'id' => 'tiprp_hookpriority',
					'type' => 'number',
					'std' => 999,
					'input_attrs' => array(
						'min' => 1
					)
				),

				array(
					'type' => 'save-button',
					'value' => 'Save',
					'class' => 'General'
				),

			array(
				'type' => 'end-container'
			),
	
			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Featured image settings','related-posts-by-themeinprogress'),
				'section' => 'featured_image_section',
			),

				array(
					'name' => esc_html__( 'Hide posts without the featured image','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'Do you want to hide all posts without the featured image?.','related-posts-by-themeinprogress'),
					'id' => 'tiprp_hide_posts_no_featured_image',
					'type' => 'switch',
					'std' => 'off'
				),

				array(
					'name' => esc_html__( 'Placeholder image','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'Do you want to view a placeholder image, if the featured image is not defined?','related-posts-by-themeinprogress'),
					'id' => 'tiprp_show_placeholder_image',
					'type' => 'switch',
					'std' => 'off'
				),

				array(
					'type' => 'save-button',
					'value' => 'Save',
					'class' => 'General'
				),

			array(
				'type' => 'end-container'
			),

			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Miscellaneous settings','related-posts-by-themeinprogress'),
				'section' => 'miscellaneous_section',
			),
	
				array(
					'name' => esc_html__( 'Remove related posts in articles where the shortcode is present','related-posts-by-themeinprogress'),
					'desc' => esc_html__( 'You can remove the related posts inside all articles and pages where our shortcode is present.', 'related-posts-by-themeinprogress'),
					'id' => 'tiprp_hide_related_posts_with_shortcode',
					'type' => 'switch',
					'std' => 'off'
				),

				array(
					'type' => 'save-button',
					'value' => 'Save',
					'class' => 'General'
				),

			array( 'type' => 'end-container'),

		array(	'type' => 'end-form'),

	),

	array(	'tab' => 'free_vs_pro',
			'element' =>

		array(	'type' => 'start-form',
				'name' => 'free_vs_pro'),

			array(
				'type' => 'start-open-container',
				'name' => esc_html__( 'Free vs Pro', 'related-posts-by-themeinprogress'),
				'section' => 'free_vs_pro_section',
			),

				array(
					'name' => esc_html__( 'Free vs Pro', 'related-posts-by-themeinprogress'),
					'type' => 'free_vs_pro'
				),

			array( 'type' => 'end-container'),

		array(	'type' => 'end-form'),

	),

	array(	'type' => 'end-tab'),

);

new tiprp_panel (
	$plugin_options,
	'tiprp_panel_',
	'tiprp_settings'
);

?>