<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * It is also available at this URL: http://www.gnu.org/licenses/gpl-3.0.txt
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/*-----------------------------------------------------------------------------------*/
/* SETTINGS */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('tiprp_setting')) {

	function tiprp_setting($id, $default = '', $is_boolean = false ) {

		$settings = get_option('tiprp_settings');

		if ( $is_boolean == true ) {

			$option = (is_array($settings) && array_key_exists($id, $settings)) ? tiprp_setting($id) : $default;
			$result = ($option == 'on') ? 'on' : 'off';

		} else {

			if(isset($settings[$id]) && !empty($settings[$id])):

				$result = $settings[$id];
	
			else:
	
				$result = $default;
	
			endif;
	
		}

		return $result;

	}

}

/*-----------------------------------------------------------------------------------*/
/* WooCommerce is active */
/*-----------------------------------------------------------------------------------*/ 

if ( ! function_exists( 'tiprp_is_woocommerce_active' ) ) {
	
	function tiprp_is_woocommerce_active( $type = "" ) {
	
        global $woocommerce;

        if ( isset( $woocommerce ) ) {
			
			if ( !$type || call_user_func($type) ) {
            
				return true;
			
			}
			
		}
	
	}

}

/*-----------------------------------------------------------------------------------*/
/* Get post meta */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('tiprp_postmeta')) {

	function tiprp_postmeta( $id, $default = '' ) {
	
		global $post, $wp_query;
		
		if (tiprp_is_woocommerce_active('is_shop')) :
	
			$content_ID = get_option('woocommerce_shop_page_id');
	
		else :
	
			$content_ID = $post->ID;
	
		endif;

		$val = get_post_meta( $content_ID , $id, TRUE);
		
		if ( !empty($val) ) :
			
			return $val;
			
		else:
				
			return $default;
			
		endif;
		
	}

}

/*-----------------------------------------------------------------------------------*/
/* GET POST AUTHOR */
/*-----------------------------------------------------------------------------------*/

if (!function_exists('tiprp_get_post_author')) {

	function tiprp_get_post_author($post_id, $show_link = true) {

		if (!is_numeric($post_id) || $post_id <= 0) {
			return '';
		}

		$author_id = get_post_field('post_author', $post_id);
		if (!$author_id) {
			return '';
		}

		$username = get_the_author_meta('user_nicename', $author_id);
		if (!$username) {
			return '';
		}

		if ($show_link) {
			$author_url = get_author_posts_url($author_id);
			return '<a href="' . esc_url($author_url) . '">' . esc_html($username) . '</a>';
		}

		return esc_html($username);

	}

}

?>
