<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

if (!function_exists('tiprp_generate_custom_css')) {

	function tiprp_generate_custom_css() {

		$css = '';

		if ( tiprp_setting('tiprp_linkscolorhover') ) :

			$css .= '
				.tiprp-wrap a:hover,
				.tiprp-wrap a:active,
				.tiprp-wrap a:focus { color:' . esc_html(tiprp_setting('tiprp_linkscolorhover')) . '!important}';
			
			$css .= '
				html[amp] .tiprp-wrap a:hover,
				html[amp] .tiprp-wrap a:active,
				html[amp] .tiprp-wrap a:focus { color:' . esc_html(tiprp_setting('tiprp_linkscolorhover')) . '!important}';

		endif;

		if ( tiprp_setting('tiprp_bordercolor') ) :

			$css .= '
				.tiprp-classic-layout section,
				.tiprp-wrap.tiprp-list-layout section { border-color:' . esc_html(tiprp_setting('tiprp_bordercolor')) . '}';
		
		endif;

        if ( tiprp_setting('tiprp_margintop') ) :

			$css .= '
				.tiprp-wrap { margin-top:' . esc_html(tiprp_setting('tiprp_margintop')) . ' !important}';

		endif;

		if ( tiprp_setting('tiprp_marginbottom') ) :

			$css .= '
				.tiprp-wrap { margin-bottom:' . esc_html(tiprp_setting('tiprp_marginbottom')) . ' !important}';

		endif;

		if ( tiprp_setting('tiprp_section_title_fontsize') ) :

			$fontSize = esc_html(tiprp_setting('tiprp_section_title_fontsize'));

			$css .= '
				.tiprp-wrap h3.tiprp-section-title { font-size:' . (intval(str_replace('px','',$fontSize))) . 'px}';

		endif;

		if ( tiprp_setting('tiprp_title_fontsize') ) :

			$fontSize = esc_html(tiprp_setting('tiprp_title_fontsize'));

			$css .= '
				.tiprp-wrap h3,
				.tiprp-hero-article h3,
				.tiprp-wp-pro-wrap h3 a { font-size:' . (intval(str_replace('px','',$fontSize))) . 'px}';

		endif;

		if ( tiprp_setting('tiprp_postmeta_fontsize') ) :

			$fontSize = esc_html(tiprp_setting('tiprp_postmeta_fontsize'));

			$css .= '
				.tiprp-wrap .tiprp-post-date,
				.tiprp-wrap .tiprp-post-author { font-size:' . (intval(str_replace('px','',$fontSize))) . 'px}';

		endif;

		if ( tiprp_setting('tiprp_postsummary_fontsize') ) :

			$fontSize = esc_html(tiprp_setting('tiprp_postsummary_fontsize'));

			$css .= '
				.tiprp-wrap .tiprp-post-summary { font-size:' . (intval(str_replace('px','',$fontSize))) . 'px}';

		endif;

		if ( tiprp_setting('tiprp_mobile_fontsize') ) :

			$fontSize = esc_html(tiprp_setting('tiprp_mobile_fontsize'));

			$css .= '
				@media screen and (min-width : 0) and (max-width : 480px) {
					.tiprp-wrap h3,
					.tiprp-hero-article h3,
					.tiprp-wp-pro-wrap h3 a,
					.tiprp-wrap h3.tiprp-section-title,
					.tiprp-wrap .tiprp-post-date,
					.tiprp-wrap .tiprp-post-author,
					.tiprp-wrap .tiprp-post-summary { font-size:' . $fontSize . '}
				}';

		endif;

		if ( tiprp_setting('tiprp_tablet_fontsize') ) :

			$fontSize = esc_html(tiprp_setting('tiprp_tablet_fontsize'));

			$css .= '
				@media screen and (min-width : 481px) and (max-width : 768px) {
					.tiprp-wrap h3,
					.tiprp-hero-article h3,
					.tiprp-wp-pro-wrap h3 a,
					.tiprp-wrap h3.tiprp-section-title,
					.tiprp-wrap .tiprp-post-date,
					.tiprp-wrap .tiprp-post-author,
					.tiprp-wrap .tiprp-post-summary { font-size:' . $fontSize . '}
				}';

		endif;

		return $css;

	}

}

if (!function_exists('tiprp_load_custom_css')) {

	function tiprp_load_custom_css() {

		$css = tiprp_generate_custom_css();
		wp_add_inline_style( 'tiprp_style', $css );

	}

	add_action('wp_enqueue_scripts', 'tiprp_load_custom_css', 999);

}

?>