<?php
 
if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

if( !class_exists( 'tiprp_admin_notice' ) ) {

	class tiprp_admin_notice {
	
		/**
		 * Constructor
		 */
		 
		public function __construct( $fields = array() ) {

			if ( !get_user_meta( get_current_user_id(), 'tiprp_notice_userid_' . get_current_user_id() , true ) ) {

				add_action( 'admin_notices', array(&$this, 'admin_notice') );
				add_action( 'admin_head', array( $this, 'dismiss' ) );
			
			}

		}

		/**
		 * Dismiss notice.
		 */
		
		public function dismiss() {

			if ( 
				isset($_GET['tiprp-dismiss']) && 
				check_admin_referer( 'tiprp-dismiss-' . get_current_user_id() )
			) {

				$notice_dismiss = (isset($_GET['tiprp-dismiss'])) ? true : false;
				update_user_meta( get_current_user_id(), 'tiprp_notice_userid_' . get_current_user_id(), $notice_dismiss );
				remove_action( 'admin_notices', array(&$this, 'admin_notice') );
				
			} 
		
		}

		/**
		 * Admin notice.
		 */
		 
		public function admin_notice() {
			
			global $pagenow;
			$redirect = ( 'admin.php' == $pagenow ) ? '?page=tiprp_panel&tiprp-dismiss=1' : '?tiprp-dismiss=1';
			
		?>
			
            <div class="update-nag notice tiprp-notice">
            
				<div class="tiprp-noticedescription">
					<strong><?php esc_attr_e( 'Upgrade to TIP Related Posts Pro to unlock premium features such as an additional layout, an optional post carousel, related posts based on post titles or custom keywords, the ability to exclude specific posts, categories, or tags, custom post type support, AMP compatibility, and much more.', 'related-posts-by-themeinprogress' ); ?></strong><br/>
					<?php printf('<a href="%1$s" class="dismiss-notice">'. esc_html__( 'Dismiss this notice', 'related-posts-by-themeinprogress' ) .'</a>', esc_url( wp_nonce_url( add_query_arg( 'tiprp-dismiss', '1' ),'tiprp-dismiss-' . get_current_user_id() ))); ?>

				</div>

                <a target="_blank" href="<?php echo esc_url( TIPRP_UPGRADE_LINK . '?ref=2&campaign=s-notice' ); ?>" class="button"><?php esc_attr_e( 'Upgrade now', 'related-posts-by-themeinprogress' ); ?></a>
                <div class="clear"></div>

            </div>
		
		<?php
		
		}

	}

}

new tiprp_admin_notice();

?>