<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

if (!function_exists('tiprp_function')) {

	function tiprp_function($atts,  $content = null) {

		extract(shortcode_atts(array(
			'enable_section_title' => NULL,
			'section_title' => NULL,
			'posts_array' => NULL,
			'layout' => NULL,
			'columns' => NULL,
			'content_align' => NULL,
			'enable_post_title' => NULL,
			'enable_post_date' => NULL,
			'enable_post_author' => NULL,
			'enable_post_author_label' => NULL,
			'enable_post_summary' => NULL,
			'target' => NULL,
			'rel' => NULL,
			'show_placeholder_image' => NULL,
		), $atts));

		if (!is_singular('post') && $posts_array == NULL)
			return;

		global $post;

		$cssClass = '';

		$postsArray = (isset($posts_array)) ? explode(',', $posts_array) : tiprp_content::getRelatedPosts($post->ID);

		$layoutsArray = array('hero-layout','list-layout','html-list-layout');
		$sectionLayout = (isset($layout) && in_array($layout, $layoutsArray) ) ? esc_attr($layout) : 'hero-layout';

		$columns =  (isset($columns)) ? esc_attr($columns) : tiprp_setting('tiprp_columns','3-columns');
		$gridColumns = str_replace('-columns','', esc_attr($columns));

		$contentAlign = (isset($content_align)) ? esc_attr($content_align) : tiprp_setting('tiprp_content_align','left');

		$enableSectionTitle = (isset($enable_section_title)) ? esc_attr($enable_section_title) : tiprp_setting('tiprp_enable_section_title', 'on', true);
		$sectionTitle = (isset($section_title)) ? esc_html($section_title) : tiprp_setting('tiprp_section_title', __( 'You may be interested', 'related-posts-by-themeinprogress' ));
		$enablePostTitle = (isset($enable_post_title)) ? esc_attr($enable_post_title) : tiprp_setting('tiprp_enable_post_title','on', true);
		$linkablePostTitle = true;
		$enablePostDate = (isset($enable_post_date)) ? esc_attr($enable_post_date) : tiprp_setting('tiprp_enable_post_date','on', true);
		$enablePostAuthor = (isset($enable_post_author)) ? esc_attr($enable_post_author) : tiprp_setting('tiprp_enable_post_author','on', true);
		$enablePostAuthorLabel = (isset($enable_post_author_label)) ? esc_attr($enable_post_author_label) : tiprp_setting('tiprp_enable_post_author_label','on', true);
		$linkablePostAuthor = true;
		$enablePostSummary = (isset($enable_post_summary)) ? esc_attr($enable_post_summary) : tiprp_setting('tiprp_enable_post_summary','on', true);

		$target = ($target == '_blank') ? 'target="_blank" ' : '';
		$rel = ($rel == 'nofollow') ? 'rel="nofollow" ' : '';
		$showPlaceholderImage = (isset($show_placeholder_image)) ? esc_attr($show_placeholder_image) : tiprp_setting('tiprp_show_placeholder_image','off', true);

		$relatedPosts = '<div class="tiprp-wrap tiprp-' . $sectionLayout . ' align-' . esc_attr($contentAlign) . '">';

		if ($enableSectionTitle == 'on') :

			$relatedPosts .= '<h3 class="tiprp-section-title">' . esc_html($sectionTitle) . '</h3>';
		
		endif;

		switch ($sectionLayout) {

			case 'html-list-layout':

				$relatedPosts .= '<ol>';
			
				foreach ( $postsArray as $postID ) {

					$fields['postID'] = $postID;
					$fields['enablePostTitle'] = $enablePostTitle;
					$fields['linkablePostTitle'] = $linkablePostTitle;
					$fields['enablePostSummary'] = $enablePostSummary;
					$fields['target'] = $target;
					$fields['rel'] = $rel;
		
					$relatedPosts .= '<li>' . tiprp_htmlListArticle($fields) . '</li>';
		
				}

				$relatedPosts .= '</ol>';

			break;

			case 'list-layout':

				$relatedPosts .= '<div>';
			
					foreach ( $postsArray as $postID ) {
						
						$fields['postID'] = $postID;
						$fields['enablePostTitle'] = $enablePostTitle;
						$fields['linkablePostTitle'] = $linkablePostTitle;
						$fields['enablePostSummary'] = $enablePostSummary;
						$fields['enablePostDate'] = $enablePostDate;
						$fields['enablePostAuthor'] = $enablePostAuthor;
						$fields['enablePostAuthorLabel'] = $enablePostAuthorLabel;
						$fields['linkablePostAuthor'] = $linkablePostAuthor;
						$fields['target'] = $target;
						$fields['rel'] = $rel;
	
						$relatedPosts .= '<section>' . tiprp_listArticle($fields) . '</section>';
			
					}
	
				$relatedPosts .= '</div>';

			break;

			case 'hero-layout':
			default:

				$cssClass .= 'tiprp-grid tiprp-grid-' . esc_attr($columns);

				$relatedPosts .= '<div class="' . esc_attr($cssClass) . '" data-columns="' . esc_attr($gridColumns) . '">';
				
					foreach ( $postsArray as $postID ) {
			
						$fields['postID'] = $postID;
						$fields['enablePostTitle'] = $enablePostTitle;
						$fields['linkablePostTitle'] = $linkablePostTitle;
						$fields['enablePostSummary'] = $enablePostSummary;
						$fields['enablePostDate'] = $enablePostDate;
						$fields['enablePostAuthor'] = $enablePostAuthor;
						$fields['enablePostAuthorLabel'] = $enablePostAuthorLabel;
						$fields['linkablePostAuthor'] = $linkablePostAuthor;
						$fields['target'] = $target;
						$fields['rel'] = $rel;
						
						$relatedPosts .= '<section>' . tiprp_heroArticle($fields) . '</section>';

					}
		
				$relatedPosts .= '</div>';

			break;

		}

		$relatedPosts .= '</div>';

		return $relatedPosts;

	}

	add_shortcode('tiprp', 'tiprp_function');

}

?>