<?php

/**
* Hero article layout
*/

if (!function_exists('tiprp_heroArticle')) {

	function tiprp_heroArticle($fields) {
	
		$html = '';
		$imgBgStyle = '';

		if ( has_post_thumbnail($fields['postID']) ) : 

			$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($fields['postID']), 'tiprp-thumbnail');
			$imgBgStyle = 'style="background-image:url(' . esc_url($thumb[0]) . ')"';

		else :

			if (tiprp_setting('tiprp_show_placeholder_image','off', true) == 'on') : 
				
				$imageURL = TIPRP_PLUGIN_FOLDER . '/assets/images/placeholder.jpg';
				$imgBgStyle = 'style="background-image:url(' . $imageURL . ')"';
			
			endif;

		endif;

		$html .= '<div class="tiprp-hero-article related-post-inner" ' . $imgBgStyle . '>';

			$html .= '<a ' . $fields['target'] . $fields['rel'] . ' title="' . esc_attr(get_the_title($fields['postID'])) . '" class="related-posts-permalink" href="' . esc_url(get_permalink($fields['postID'])) . '"></a>';

			$html .= '<div class="related-posts-details">';

				$html .= '<div class="related-post-inner" style="display:block">';

					$html .= '<div class="related-post-inner-details">';

						$html .= tiprp_getPostTitle(
							$fields['postID'],
							$fields['target'],
							$fields['rel'],
							$fields['enablePostTitle'],
							'off',
						);
		
						$html .= tiprp_getPostMeta(
							$fields['postID'],
							$fields['enablePostDate'],
							$fields['enablePostAuthor'],
							$fields['enablePostAuthorLabel']
						);
		
						$html .= tiprp_getPostSummary(
							$fields['postID'],
							$fields['enablePostSummary']
						);
				
					$html .= '</div>';

				$html .= '</div>';

			$html .= '</div>';

		$html .= '</div>';

		return $html;

	}

}

/**
* List article layout
*/

if (!function_exists('tiprp_listArticle')) {

	function tiprp_listArticle($fields) {

		$html = '';

		$html .= '<div class="tiprp-list-article">';

			$html .= '<div class="tiprp-classic-list-details">';

				$html .= tiprp_getPostTitle(
					$fields['postID'],
					$fields['target'],
					$fields['rel'],
					$fields['enablePostTitle'],
				);

				$html .= tiprp_getPostMeta(
					$fields['postID'],
					$fields['enablePostDate'],
					$fields['enablePostAuthor'],
					$fields['enablePostAuthorLabel']
				);

				$html .= tiprp_getPostSummary(
					$fields['postID'],
					$fields['enablePostSummary']
				);

			$html .= '</div>';

		$html .= '</div>';

		return $html;

	}

}

/**
* HTML list article layout
*/

if (!function_exists('tiprp_htmlListArticle')) {

	function tiprp_htmlListArticle($fields) {

		$html = tiprp_getPostTitle(
			$fields['postID'],
			$fields['target'],
			$fields['rel'],
			'on',
			$fields['linkablePostTitle'],
		);

		return $html;

	}

}

?>
