<?php

/**
* Get post title
*/

if (!function_exists('tiprp_getPostTitle')) {

	function tiprp_getPostTitle($postID, $target, $rel, $enablePostTitle = 'off') {

		$html = '';
		$post_title = '';

		$get_the_post_title = get_the_title($postID);

		if ($enablePostTitle == 'on' ) :
			
			$post_title .= '<a ' . $target . $rel . ' href="' . esc_url(get_permalink($postID)) . '">';
			$post_title .= esc_html($get_the_post_title);
			$post_title .= '</a>';

			$html .= '<h3>' . $post_title . '</h3>';

		endif;

		return $html;

	}

}

/**
* Get post summary
*/

if (!function_exists('tiprp_getPostSummary')) {

	function tiprp_getPostSummary($postID, $enablePostSummary) {

		$html = '';
		$excerpt = wp_trim_words(get_post_field( 'post_content', $postID ), 10 , '...' );

		if ($enablePostSummary == 'on' ) :
					
			$html .= '<p class="tiprp-post-summary">' . esc_html($excerpt) . ' </p>';

		endif;

		return $html;

	}

}

/**
* Get post date
*/

if (!function_exists('tiprp_getPostDate')) {

	function tiprp_getPostDate($postID, $enablePostDate) {

		$html = '';

		if ($enablePostDate == 'on' ) :
					
			$html .= '<span class="tiprp-post-date">' . esc_html(get_the_date('l, F j Y', $postID)) . '</span>';

		endif;

		return $html;

	}

}

/**
* Get post author
*/

if (!function_exists('tiprp_getPostAuthor')) {

	function tiprp_getPostAuthor($postID, $enablePostDate,$enablePostAuthor, $enablePostAuthorLabel) {

		$html = '';

		if ($enablePostAuthor == 'on' ) :
					
			$html .= '<span class="tiprp-post-author">';

			if ($enablePostAuthorLabel == 'on' ) :
					
				$html .= esc_html(__( 'By', 'related-posts-by-themeinprogress' ) . '&nbsp;');

			endif;

			$html .= tiprp_get_post_author($postID, true);

			$html .= '</span>';

		endif;

		return $html;

	}

}

/**
* Get post meta
*/

if (!function_exists('tiprp_getPostMeta')) {

	function tiprp_getPostMeta($postID, $enablePostDate, $enablePostAuthor, $enablePostAuthorLabel) {

		$html = '';

		if (
			$enablePostDate == 'on' ||
			$enablePostAuthor == 'on'
		) :

			$html .= '<div class="tiprp-post-meta">';

				$html .= tiprp_getPostDate($postID, $enablePostDate);
				$html .= tiprp_getPostAuthor($postID, $enablePostDate, $enablePostAuthor, $enablePostAuthorLabel);

			$html .= '</div>';

		endif;

		return $html;

	}

}

?>