<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/*
Plugin Name: Related Posts by ThemeinProgress
Plugin URI: https://www.themeinprogress.com/tip-related-posts/
Description: Related Posts by ThemeinProgress is the perfect plugin to easily display related posts in your WordPress articles.
Version: 1.0.0
Text Domain: related-posts-by-themeinprogress
Author: ThemeinProgress
Author URI: https://www.themeinprogress.com
License: GPL3
Domain Path: /languages/

Copyright 2025  ThemeinProgress  (email : support@wpinprogress.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

define( 'TIPRP_NAME', 'Related Posts by ThemeinProgress' );
define( 'TIPRP_VERSION', '1.0.0' );
define( 'TIPRP_FOLDER', dirname(__FILE__) );
define( 'TIPRP_PLUGIN_FOLDER', plugins_url(false, __FILE__ ) );
define( 'TIPRP_DEMO_URL', 'https://demo.themeinprogress.eu/tip-related-posts-pro/documentation-free-version/' );
define( 'TIPRP_UPGRADE_LINK', 'https://www.themeinprogress.com/related-posts-pro-wordpress-plugin-by-themeinprogress/' );
define( 'TIPRP_SALE_PAGE', 'https://www.themeinprogress.com/related-posts-pro-wordpress-plugin-by-themeinprogress/?ref=2&campaign=');

if( !class_exists( 'tiprp_init' ) ) {

	class tiprp_init {

		/**
		* Constructor
		*/

		public function __construct() {

			add_action('plugins_loaded', array(&$this, 'plugin_setup') );
			add_action('init', array(&$this, 'plugin_init') );
			add_action('wp_loaded', array(&$this, 'plugin_panel') );
			add_filter('plugin_action_links_' . plugin_basename(__FILE__), array( $this, 'plugin_action_links' ), 10, 2 );
			add_action('wp_enqueue_scripts', array(&$this,'site_scripts'));

		}

		/**
		* Plugin settings link
		*/

		public function plugin_action_links( $links ) {

			$links[] = '<a href="'. esc_url( get_admin_url(null, 'admin.php?page=tiprp_panel') ) .'">' . esc_html__('Settings','related-posts-by-themeinprogress') . '</a>';
			$links[] = '<a target="_blank" href="'. esc_url(TIPRP_SALE_PAGE . 'action_link') .'">' . esc_html__('Upgrade to PRO','related-posts-by-themeinprogress') . '</a>';

			return $links;

		}

		/**
		* Site scripts
		*/

		public function site_scripts() {
			
			wp_enqueue_style (
				'tiprp_style',
				plugins_url('/assets/css/style.css', __FILE__ ),
				array(),
				null
			);

		}

        /**
		* Plugin setup
		*/

		public function plugin_setup() {

			include_once(ABSPATH.'wp-admin/includes/plugin.php');

			require_once dirname(__FILE__) . '/core/ui/post-elements.php';
			require_once dirname(__FILE__) . '/core/ui/layouts.php';

			require_once dirname(__FILE__) . '/core/functions/functions.php';
			require_once dirname(__FILE__) . '/core/functions/style.php';

			require_once dirname(__FILE__) . '/core/shortcodes/default.php';

			require_once dirname(__FILE__) . '/core/includes/class-related-posts.php';
			require_once dirname(__FILE__) . '/core/includes/class-form.php';
			require_once dirname(__FILE__) . '/core/includes/class-panel.php';
			require_once dirname(__FILE__) . '/core/includes/class-notice.php';
            
            add_image_size(
				'tiprp-thumbnail',
				450,
				360,
				true
			);

		}

		/**
		* Plugin init
		*/

		public function plugin_init() {

			load_plugin_textdomain( 'related-posts-by-themeinprogress', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/');

		}

		/**
		* Plugin panel
		*/

		public function plugin_panel() {

			if ( is_admin() == 1 ) {

				require_once dirname(__FILE__) . '/core/admin/plugin_options.php';

			}

		}

	}

	new tiprp_init();

}

?>