<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

if( !class_exists( 'tiprp_panel' ) ) {

	class tiprp_panel {

		/**
		 * Constructor
		 */

		public $panel_fields;
		public $plugin_slug;
		public $plugin_optionname;

		public function __construct($panel_fields, $plugin_slug, $plugin_optionname) {

			$this->panel_fields = $panel_fields;
			$this->plugin_slug = $plugin_slug;
			$this->plugin_optionname = $plugin_optionname;

			add_action('admin_menu', array(&$this, 'admin_menu') ,11);
			add_action('admin_init', array(&$this, 'add_script') ,11);
			add_action('admin_init', array(&$this, 'default_settings') ,11);
			add_action('admin_init', array(&$this, 'save_option') ,11);

		}

		/**
		 * Create option panel menu
		 */

		public function admin_menu() {

			global $admin_page_hooks;

			if ( !isset( $admin_page_hooks['tip_plugins_panel']) ) :

				add_menu_page(
					esc_html__('TIP Plugins', 'related-posts-by-themeinprogress'),
					esc_html__('TIP Plugins', 'related-posts-by-themeinprogress'),
					'manage_options',
					'tip_plugins_panel',
					NULL,
					plugins_url('/assets/images/tip-icon.png', dirname(__FILE__)),
					64
				);

			endif;

			add_submenu_page(
				'tip_plugins_panel',
				esc_html__('Related Posts by ThemeinProgress', 'related-posts-by-themeinprogress'),
				esc_html__('Related Posts by ThemeinProgress', 'related-posts-by-themeinprogress'),
				'manage_options',
				'tiprp_panel',
				array(&$this, 'tiprp_panel')
			);

			if ( isset( $admin_page_hooks['tip_plugins_panel'] ) )
				remove_submenu_page( 'tip_plugins_panel', 'tip_plugins_panel' );

		}

		/**
		 * Loads the plugin scripts and styles
		 */

		public function add_script() {

			global $wp_version, $pagenow;

			$file_dir = plugins_url('/assets/', dirname(__FILE__));

			wp_enqueue_style ( 'tiprp_notice', $file_dir.'css/notice.css' );

			if ( $pagenow == 'admin.php' ) {

				wp_enqueue_style ( 'wp-color-picker' );
				wp_enqueue_style ( 'tiprp_panel', $file_dir.'css/panel.css' );
				wp_enqueue_style ( 'tiprp_panel_googlefonts', '//fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i');
				wp_enqueue_style ( 'tiprp_panel_switch', $file_dir.'css/switch.css' );
				wp_enqueue_style ( 'tiprp_free_pro_table', $file_dir.'css/free_pro_table.css' );

				wp_enqueue_script( 'jquery');
				wp_enqueue_script( 'jquery-ui-core', array('jquery'));
				wp_enqueue_script( 'jquery-ui-tabs', array('jquery'));
				wp_enqueue_script( 'tiprp_panel', $file_dir.'js/panel.js',array('jquery','thickbox', 'wp-color-picker'),'1.0',TRUE );

				wp_localize_script( 'tiprp_panel', 'tiprp_pluginData', array(
					'path'   => $file_dir )
				);

			}

		}

		/**
		 * Message after the options saving
		 */

		public function save_message () {

			global $tiprp_message;

			if (isset($tiprp_message))
				echo '<div id="message" class="updated fade message_save ' . esc_attr($this->plugin_slug) . 'message"><p><strong> ' . esc_html($tiprp_message) . '</strong></p></div>';

		}

		/**
		 * Sanitize layout function
		 */

		 public function sanitize_layout_function($k) {

			$allowedOptions = array(
				'hero-layout',
				'list-layout',
				'html-list-layout',
			);

			if ( in_array($k, $allowedOptions)) {

				return $k;

			} else {

				return 'hero-layout';

			}

		}

		/**
		 * Sanitize columns function
		 */

		public function sanitize_columns_function($k) {

			$allowedOptions = array(
				'1-column',
				'2-columns',
				'3-columns',
			);

			if ( in_array($k, $allowedOptions)) {

				return $k;

			} else {

				return '3-columns';

			}

		}

		/**
		 * Sanitize align function
		 */

		 public function sanitize_content_align_function($k) {

			$allowedOptions = array(
				'left',
				'center',
				'right',
			);

			if ( in_array($k, $allowedOptions)) {

				return $k;

			} else {

				return 'center';

			}

		}

		/**
		 * Sanitize count function
		 */

		public function sanitize_enginesearch_function($k) {

			$allowedOptions = array(
				'categories',
				'tags',
			);

			if ( in_array($k, $allowedOptions)) {

				return $k;

			} else {

				return 'categories';

			}

		}

		/**
		 * Sanitize post title filtering function
		 */

		public function sanitize_post_title_filtering_function($k) {

			$allowedOptions = array(
				'disable',
				'include',
				'exclude',
			);

			if ( in_array($k, $allowedOptions)) {

				return $k;

			} else {

				return 'exclude';

			}

		}

		/**
		 * Sanitize search engine page function
		 */

		 public function sanitize_search_engine_page_function($k) {

			$allowedOptions = array(
				'child_pages',
				'custom_keywords',
			);

			if ( in_array($k, $allowedOptions)) {

				return $k;

			} else {

				return 'child_pages';

			}

		}

		/**
		 * Sanitize boolean function
		 */

		public function sanitize_targetattribute_function($k) {

			return ( $k == '_blank' ) ? '_blank' : '';

		}

		/**
		 * Sanitize boolean function
		 */

		public function sanitize_relattribute_function($k) {

			return ( $k == 'nofollow' ) ? 'nofollow' : '';

		}

		/**
		 * Sanitize boolean function
		 */

		public function sanitize_pixel_function($k) {

			return absint(str_replace('px', '', $k)) . 'px';

		}

		/**
		 * Sanitize SwitchOn function
		 */

		public function sanitize_switchOn_function($value) {

			return ($value == 'on') ? 'on' : '';

		}

		/**
		* Multidimensional Array sanitize function
		*/

		public function array_sanitize_function($id, $value) {

			switch ($id) {

				case 'tiprp_section_title':

					$tosave = sanitize_text_field($value);

				break;

				case 'tiprp_margintop':
				case 'tiprp_marginbottom':
				case 'tiprp_section_title_fontsize':
				case 'tiprp_title_fontsize':
				case 'tiprp_postmeta_fontsize':
				case 'tiprp_postsummary_fontsize':
				case 'tiprp_mobile_fontsize':
				case 'tiprp_tablet_fontsize':
				case 'tiprp_amp_fontsize':

					$tosave = $this->sanitize_pixel_function($value);

				break;

				case 'tiprp_layout':

					$tosave = $this->sanitize_layout_function($value);

				break;

				case 'tiprp_columns':

					$tosave = $this->sanitize_columns_function($value);

				break;

				case 'tiprp_content_align':

					$tosave = $this->sanitize_content_align_function($value);

				break;

				case 'tiprp_linkscolorhover':
				case 'tiprp_bordercolor':
				case 'tiprp_navs_color':
				case 'tiprp_navs_color_hover':
				case 'tiprp_dots_color':
				case 'tiprp_dots_color_hover':

					$tosave = sanitize_hex_color($value);

				break;

				case 'tiprp_enginesearch':

					$tosave = $this->sanitize_enginesearch_function($value);

				break;

				case 'tiprp_targetattribute':

					$tosave = $this->sanitize_targetattribute_function($value);

				break;

				case 'tiprp_relattribute':

					$tosave = $this->sanitize_relattribute_function($value);

				break;

				case 'tiprp_count':
				case 'tiprp_amp_count':
				case 'tiprp_hookpriority':

					$tosave = absint($value);

				break;

				case 'tiprp_enable_section_title':
				case 'tiprp_enable_post_title':
				case 'tiprp_enable_post_date':
				case 'tiprp_enable_post_author':
				case 'tiprp_enable_post_author_label':
				case 'tiprp_enable_post_summary':
				case 'tiprp_enable_carousel':
				case 'tiprp_enable_carousel_nav':
				case 'tiprp_enable_carousel_dots':
				case 'tiprp_show_placeholder_image':
				case 'tiprp_hide_related_posts_with_shortcode':
				case 'tiprp_hide_posts_no_featured_image':

					$tosave = $this->sanitize_switchOn_function($value);

				break;

				case 'tiprp_enable_cpt':

					$tosave = $this->sanitize_cpt_function($value);

				break;

				case 'tiprp_include_specific_words':
				case 'tiprp_exclude_specific_words':

					$tosave = sanitize_textarea_field($value);

				break;

				case 'tiprp_post_title_filtering':

					$tosave = $this->sanitize_post_title_filtering_function($value);

				break;

				case 'tiprp_search_engine_page':

					$tosave = $this->sanitize_search_engine_page_function($value);

				break;

			}

			return $tosave;

		}

		/**
		 * Default settings function
		 */

		public function default_settings() {

			global $pagenow;

			$tiprp_setting = get_option($this->plugin_optionname);

			if ( $tiprp_setting != false ) :

				$tiprp_setting = maybe_unserialize( get_option( $this->plugin_optionname ) );

			else :

				$tiprp_setting = array();

			endif;

		}

		/**
		 * Save options function
		 */

		public function save_option() {

			global $tiprp_message;

			$tiprp_setting = get_option($this->plugin_optionname);

			if ( $tiprp_setting != false ) :

				$tiprp_setting = maybe_unserialize( get_option( $this->plugin_optionname ) );

			else :

				$tiprp_setting = array();

			endif;

			if ( $this->tiprp_request('tiprp_save_settings_action') !== null ) {

				if (
					!current_user_can('manage_options') ||
					!isset($_POST['tiprp_save_nonces']) ||
					!wp_verify_nonce(sanitize_key($_POST['tiprp_save_nonces']), 'tiprp_save_options' )
				) {
					exit;
				}

				foreach ( $this->panel_fields as $element ) {

					if (
						isset($_GET['tab']) && 
						isset($element['tab']) && 
						$element['tab'] == $_GET['tab']
					) {
	
						foreach ($element as $value ) {

							if ( isset($value['id']) ) {

								if (
									(
										strpos($value["id"], 'toexclude') ||
										$value["id"] == 'tiprp_hide_related_posts_with_shortcode'
									)
									&& !isset($_POST[$value["id"]])) {

									$current[$value['id']] = array();

								} else {

									if (

										$value['id'] == 'tiprp_enable_section_title' ||
										$value['id'] == 'tiprp_enable_post_title' ||
										$value['id'] == 'tiprp_enable_post_date' ||
										$value['id'] == 'tiprp_enable_post_author' ||
										$value['id'] == 'tiprp_enable_post_author_label' ||
										$value['id'] == 'tiprp_enable_post_summary' ||
										$value['id'] == 'tiprp_enable_carousel' ||
										$value['id'] == 'tiprp_enable_carousel_nav' ||
										$value['id'] == 'tiprp_enable_carousel_dots' ||
										$value['id'] == 'tiprp_show_placeholder_image' ||
										$value['id'] == 'tiprp_hide_posts_no_featured_image'

									) {

										$newOption = (isset($_POST[$value["id"]])) ? 'on' : 'off';

									} else {

										$newOption = $_POST[$value["id"]];

									}

									$current[$value['id']] = $this->array_sanitize_function($value['id'], $newOption);
								}

								update_option($this->plugin_optionname, array_merge( $tiprp_setting, $current) );

							}

							$tiprp_message = esc_html__('Options saved successfully.', 'related-posts-by-themeinprogress' );

						}

					}

				}

			}

		}

		/**
		 * Request function
		 */

		public function tiprp_request($id) {
			
			if ( $id == 'tiprp_save_settings_action' && isset($_REQUEST[$id]) ) {
				return sanitize_text_field($_REQUEST[$id]);
			}

		}

		/**
		 * Option panel
		 */

		public function tiprp_panel() {

			global $tiprp_message;

			$tiprpForm = new tiprp_form();

			$plugin_slug =  $this->plugin_slug;

			if (!isset($_GET['tab']))
				$_GET['tab'] = "Plugin_Settings";

			foreach ( $this->panel_fields as $element) {

				if (isset($element['type'])) :

					switch ( $element['type'] ) {

						case 'navigation':

							echo $tiprpForm->elementStart('div', $plugin_slug . 'tabs', FALSE );

								echo $tiprpForm->elementStart('div', $plugin_slug . 'header', FALSE );

									echo $tiprpForm->elementStart('div', FALSE, 'left plugin_description' );

										echo $tiprpForm->element('h2', FALSE, 'maintitle', esc_html__( 'Related Posts by ThemeinProgress','related-posts-by-themeinprogress'));
										echo $tiprpForm->element('span', FALSE, FALSE, esc_html__( 'Version: ','related-posts-by-themeinprogress') . TIPRP_VERSION);
										echo $tiprpForm->link('https://www.themeinprogress.com', FALSE, FALSE, '_blank', FALSE, esc_html__( 'by ThemeinProgress','related-posts-by-themeinprogress') );
										echo $tiprpForm->link(TIPRP_DEMO_URL, FALSE, FALSE, '_blank', FALSE, esc_html__( ' - Documentation','related-posts-by-themeinprogress') );

									echo $tiprpForm->elementEnd('div');

									echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

								echo $tiprpForm->elementEnd('div');

								$this->save_message();

								echo $tiprpForm->htmlList('ul', FALSE, $plugin_slug . 'navigation', $element['item'], sanitize_text_field(wp_unslash($_GET['tab'])));

						break;

						case 'end-tab':

								echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

							echo $tiprpForm->elementEnd('div');

						break;

					}

				endif;

			if (isset($element['tab'])) :

				switch (sanitize_text_field($element['tab'])) {

					case sanitize_text_field(wp_unslash($_GET['tab'])):

						foreach ($element as $value) {

							if (isset($value['type'])) :

								switch ( $value['type'] ) {

								case 'start-form':

									echo $tiprpForm->elementStart('div', str_replace(' ', '', $value['name']), FALSE );

										echo $tiprpForm->formStart('post', '?page=tiprp_panel&tab=' . sanitize_text_field(wp_unslash($_GET['tab'])));
										echo $tiprpForm->input('tiprp_save_nonces', FALSE, FALSE, 'hidden', esc_attr(wp_create_nonce( 'tiprp_save_options' )));

								break;

								case 'end-form':

										echo $tiprpForm->formEnd();

									echo $tiprpForm->elementEnd('div');

								break;

								case 'start-section':

									echo $tiprpForm->elementStart('div', FALSE, $value['class'] );

								break;

								case 'end-section':

									echo $tiprpForm->elementEnd('div');

								break;

								case 'start-open-container':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'container ' . $plugin_slug . $value['section']);

										echo $tiprpForm->element('h5', FALSE, 'element-open', $value['name'] );

										echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'mainbox tiprp_openbox' );

								break;

								case 'end-container':

										echo $tiprpForm->elementEnd('div');

									echo $tiprpForm->elementEnd('div');

								break;

								case 'section-title':

									echo $tiprpForm->element('h5', FALSE, 'section-title', $value['name'] );

								break;

								case 'section-subtitle':

									echo $tiprpForm->element('h6', FALSE, 'section-subtitle', $value['name'] );

								break;

								case 'checkbox':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box');

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->checkbox($value['id'], $value['options'], tiprp_setting($value['id']));
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'text':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box' );

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->input($value['id'], $value['id'], FALSE, $value['type'], sanitize_text_field(tiprp_setting($value['id'], $value['std'])));
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'number':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box' );

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->input($value['id'], $value['id'], FALSE, $value['type'], sanitize_text_field(tiprp_setting($value['id'], $value['std'])), $value['input_attrs']);
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'license_key':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box' );

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											$maskedKey = (get_option($value['id']) != '') ? substr_replace(get_option($value['id']),'********************', 5, 20) : '';

											echo $tiprpForm->input($value['id'], $value['id'], FALSE, 'text', $maskedKey);
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case "upload":

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box');

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->input($value['id'], $value['id'], 'upload_attachment', 'text', tiprp_setting($value['id'], $value['std']));
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);
											echo $tiprpForm->input(FALSE, FALSE, 'button upload_button', 'button', esc_attr__('Upload', 'related-posts-by-themeinprogress'));

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'textarea':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box');

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->textarea($value['id'], $value['id'], FALSE, sanitize_textarea_field(tiprp_setting($value['id'], $value['std'])), FALSE);
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'switch':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box tiprp_inputbox tiprp_checkbox tiprp_checkbox ' . esc_attr($value['id']));
									
										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											$switchOption = (is_array(get_option('tiprp_settings')) && array_key_exists($value['id'], get_option('tiprp_settings'))) ? tiprp_setting($value['id']) : $value['std'];

											echo $tiprpForm->switchOn($value['id'], esc_attr($value['id']), 'on-off', $switchOption );

											echo $tiprpForm->elementStart('div', FALSE, 'switch-container' );
												echo $tiprpForm->element('span', FALSE, 'switch', FALSE);
											echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'select':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box');

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->select($value['id'], $value['id'], FALSE, $value['options'], tiprp_setting($value['id'], $value['std']), FALSE);
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case "save-button":

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box ' . $plugin_slug . 'save_button');

										echo $tiprpForm->input('tiprp_save_settings_action', FALSE, 'button', 'submit', esc_html__('Save settings', 'related-posts-by-themeinprogress' ));

									echo $tiprpForm->elementEnd('div');

								break;

								case 'color':

									echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box' );

										echo $tiprpForm->elementStart('div', FALSE, 'input-left' );

											echo $tiprpForm->label($value['id'], $value['name']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->elementStart('div', FALSE, 'input-right' );

											echo $tiprpForm->color($value['id'], $value['id'], $plugin_slug . 'color', 'text', sanitize_hex_color(tiprp_setting($value['id'], $value['std'])), $value['std']);
											echo $tiprpForm->element('p', FALSE, FALSE, $value['desc']);

										echo $tiprpForm->elementEnd('div');

										echo $tiprpForm->element('div', FALSE, 'clear', FALSE);

									echo $tiprpForm->elementEnd('div');

								break;

								case 'free_vs_pro':

								echo $tiprpForm->elementStart('div', FALSE, $plugin_slug . 'box' );

									echo $tiprpForm->tableStart(FALSE, $plugin_slug . ' card table free-pro', 0, 0 );

									echo $tiprpForm->tableElementStart('tbody', FALSE, 'table-body');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'table-head');

											echo $tiprpForm->tableElement('th', FALSE, 'large');

											echo $tiprpForm->tableElementStart('th', FALSE, 'indicator');
												echo esc_html__('Free', 'related-posts-by-themeinprogress');
											echo $tiprpForm->tableElementEnd('th');

											echo $tiprpForm->tableElementStart('th', FALSE, 'indicator');
												echo esc_html__('Premium', 'related-posts-by-themeinprogress');
											echo $tiprpForm->tableElementEnd('th');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Custom colors', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Option to edit the section title', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Typography settings', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Option to edit the top and bottom margin', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Related posts based of post category', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Related posts based of post tag', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Option to edit the_content hook priority', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Shortcode', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE );

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Layouts', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo esc_html__('3', 'related-posts-by-themeinprogress');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo esc_html__('4', 'related-posts-by-themeinprogress');

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Columns', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo esc_html__('1 to 3', 'related-posts-by-themeinprogress');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo esc_html__('1 to 5', 'related-posts-by-themeinprogress');

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Number of related posts', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo esc_html__('Unlimited', 'related-posts-by-themeinprogress');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo esc_html__('Unlimited', 'related-posts-by-themeinprogress');

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Carousel', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('Display a carousel of related posts (available only with the Classic and Hero layouts)', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');
										
										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Related posts based of category and post tags', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('Besides the options available on the free version, you can load the related posts based of categories and post tags.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Options to manage the featured image', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('Set the thumbnail size and choose how to resize the image: maintain the aspect ratio or crop the image to the specified dimensions.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Additional options to manage the post elements.', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('Additional options to manage the post elements, such as linking the title to the content, the author to their page, customizing the "Author" label, and truncating long content with ellipsis.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Option to exclude specific categories', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can select one or more categories to exclude from the related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Option to exclude specific tags', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can select one or more post tags to exclude from the related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Option to exclude specific posts', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can select one or more posts to exclude from the related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Custom keywords', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can use custom keywords as Engine Search but you will need to set the keywords for each post to generate the list of related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Device selection', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can select the device where you want to display the related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');
										
										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Order by option', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can select how to order the related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Sort order option', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can select the ordering of related posts.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Shortcode generator', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('Use a dynamic shortcode generator to add a specific related posts inside the WordPress article.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('AMP support', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('Display rightly the related posts in AMP pages.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Custom post types support', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can enable the related posts for specific custom post types.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('WordPress pages support', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can enable related content for WordPress pages as well. Related pages will be automatically determined based on keywords or the parent-child relationship between pages.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Backup section', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('You can create a backup of plugin settings, import an existing backup or restore the default settings.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'feature-row');

											echo $tiprpForm->tableElementStart('td', FALSE, 'large');

												echo $tiprpForm->elementStart('div', FALSE, 'feature-wrap' );

													echo $tiprpForm->elementStart('h4', FALSE, FALSE );

														echo esc_html__('Automatic data import', 'related-posts-by-themeinprogress');

													echo $tiprpForm->elementEnd('h4');

													echo $tiprpForm->elementStart('div', FALSE, 'feature-inline-row' );

														echo $tiprpForm->element('span', FALSE, 'info-icon dashicon dashicons dashicons-info', FALSE );

														echo $tiprpForm->elementStart('span', FALSE, 'feature-description' );

															echo esc_html__('After the activation of TIP Related Posts Pro, all settings will be imported automatically from the free version.', 'related-posts-by-themeinprogress');

														echo $tiprpForm->elementEnd('span');

													echo $tiprpForm->elementEnd('div');

												echo $tiprpForm->elementEnd('div');

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-no-alt', FALSE);

											echo $tiprpForm->tableElementEnd('td');

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->element('span', FALSE, 'dashicon dashicons dashicons-yes', FALSE);

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

										echo $tiprpForm->tableElementStart('tr', FALSE, 'upsell-row');

											echo $tiprpForm->tableElement('td', FALSE, FALSE);
											echo $tiprpForm->tableElement('td', FALSE, FALSE);

											echo $tiprpForm->tableElementStart('td', FALSE, 'indicator');

												echo $tiprpForm->link(esc_url(TIPRP_SALE_PAGE . 'ilrc-freepro-table'), FALSE, 'button button-primary', '_blank', FALSE, esc_html__( 'Upgrade to Premium','related-posts-by-themeinprogress') );

											echo $tiprpForm->tableElementEnd('td');

										echo $tiprpForm->tableElementEnd('tr');

									echo $tiprpForm->tableElementEnd('tbody');

									echo $tiprpForm->tableEnd();

								echo $tiprpForm->elementEnd('div');

								break;

								}

							endif;

						}

					}

				endif;

			}

		}

	}

}

?>