<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

if( !class_exists( 'tiprp_content' ) ) {

	class tiprp_content {

		/**
		* Constructor
		*/

		public function __construct() {
			
			add_filter(
				'the_content',
				array(&$this, 'putRelatedPosts'),
				tiprp_setting('tiprp_hookpriority', '999')
			);
			
		}

		/**
		* Get categories of current post
		*/

        public static function getPostCategories($postID) {

			$catsArray = array();

            foreach (get_the_category($postID) as $cat) {
                $catsArray[] = sanitize_text_field($cat->term_id);
            }

            return $catsArray;

        }
        
		/**
		* Get tags of current post
		*/
        
        public static function getPostTags($postID) {

			$tagsArray = array();

            foreach (wp_get_post_tags($postID) as $tag) {
                $tagsArray[] = sanitize_text_field($tag->term_id);
            }

            return $tagsArray;

        }
        
		/**
		* Get related posts
		*/

        public static function getRelatedPosts($postID, $loopArgs = array()) {

			$catsArray = array();
			$tagsArray = array();

			$engine = (array_key_exists('engine', $loopArgs)) ? $loopArgs['engine'] : tiprp_setting('tiprp_enginesearch', 'categories');

			if ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) {
				$posts_per_page = tiprp_setting('tiprp_amp_count', 3);
			} else {
				$posts_per_page = tiprp_setting('tiprp_count', 3);
			}

			$args = array(
				'post_type' => 'post',
				'posts_per_page' => $posts_per_page,
				'post_status' => 'publish',
				'orderby' => 'date',
				'order' => 'asc',
				'fields' => 'ids',
				'post__not_in' => array($postID)
			);

			if ( tiprp_setting('tiprp_hide_posts_no_featured_image','off', true) == 'on' ) :
				$args['meta_key'] = '_thumbnail_id';
			endif;

			switch ($engine) {

				case 'categories':
				default:
                    
                    $catsArray = static::getPostCategories($postID);
                    
                    $engineSearchArgs = array(

                        'tax_query' => array(
                             array(
                                'taxonomy' => 'category',
                                'field' => 'term_id',
                                'terms' => $catsArray,
                                'operator' => 'IN'
                             ),
                        )

                    );
                    
				break;
				
                case 'tags':

                    $tagsArray = static::getPostTags($postID);

					$engineSearchArgs = array(

						'tax_query' => array(
							 array(
								'taxonomy' => 'post_tag',
								'field' => 'term_id',
								'terms' => $tagsArray,
								'operator' => 'IN'
							 ),
						)

					);

				break;

			}
			
			$return = get_posts(array_merge($args, $engineSearchArgs));

			return $return;

		}

		/**
		* Put related posts
		*/

		public function putRelatedPosts($content) {

			global $post;

			$postsArray = $this->getRelatedPosts($post->ID, array());
			$posts_array = implode(",", $postsArray);
			
			if (
				count($postsArray) > 0 &&
				(
					!has_shortcode( $post->post_content, 'tiprp') ||
					(
						tiprp_setting('tiprp_hide_related_posts_with_shortcode', 'off', true) == 'off' &&
						has_shortcode( $post->post_content, 'tiprp')
					)

				) &&
				in_array(get_post_type($post->ID), tiprp_setting('tiprp_enable_cpt', array('post')))

			) :

				$relatedPosts  =  '[tiprp';

				$relatedPosts .= ' posts_array="' . esc_attr($posts_array) . '" ';

				$relatedPosts .= ' layout="' . esc_attr(tiprp_setting('tiprp_layout', 'classic-layout')) . '" ';
				$relatedPosts .= ' columns="' . esc_attr(tiprp_setting('tiprp_columns','3-columns')) . '" ';
				$relatedPosts .= ' target="' . esc_attr(tiprp_setting('tiprp_targetattribute', '')) . '" ';
				$relatedPosts .= ' rel="' . esc_attr(tiprp_setting('tiprp_relattribute', '')) . '" ';
	
				$relatedPosts .= ']';

				$relatedPosts = do_shortcode($relatedPosts);

				return $content . $relatedPosts;

			else:

				return $content;

			endif;

		}

	}

	new tiprp_content();

}

?>